#include <bits/stdc++.h>

using namespace std;


using ll = long long;

struct hlopok {
    ll t, x;
};


struct line {
    vector<pair<ll, ll>> s;

    line () {
        s.emplace_back(0, 0);
    }

    void incr(ll d) {
        for (auto& [l, r] : s) {
            l -= d;
            r += d;
        }
    }

    void upd() {
        if (s.empty()) return;
        ll fromL = s[0].first;
        ll lastR = s[0].second;
        vector<pair<ll, ll>> v;
        for (int i = 1; i < s.size(); ++i) {
            auto [l, r] = s[i];
            if (l > r) {
                continue;
            }
            if (l <= lastR) {
                lastR = max(lastR, r);
            } else {
                v.emplace_back(fromL, lastR);
                fromL = l;
                lastR = r;
            }
        }
        v.emplace_back(fromL, lastR);
        s = v;
    }

    void ban(ll lx, ll rx) {
        vector<pair<ll, ll>> v;
        for (auto [l, r] : s) {
            if (lx <= l && r <= rx) {
                continue;
            } else if (lx <= l && l <= rx) {
                v.emplace_back(rx + 1, r);
            } else if (lx <= r && r <= rx) {
                v.emplace_back(l, lx - 1);
            } else if (l <= lx && rx <= r) {
                v.emplace_back(l, lx - 1);
                v.emplace_back(rx + 1, r);
            } else {
                v.emplace_back(l, r);
            }
        }
        s = v;
    }
};

bool check(const map<ll, vector<ll>>& mp, ll d) {
    if (d == 0) {
        return true;
    }
    --d;
    vector<pair<ll, ll>> segments;
    for (const auto& [t, v] : mp) {
        for (const auto x : v) {
            ll l = max(-2 * t, x - d), r = min(2 * t, x + d);
            if (l <= r) {
                segments.emplace_back(l, r);
            }
        }
    }
    sort(segments.begin(), segments.end());
    ll fromL = segments[0].first, toR = segments[0].second;
    for (int i = 1; i < segments.size(); ++i) {
        auto [l, r] = segments[i];
        if (l <= toR + 1) {
            toR = max(toR, r);
        } else {
            return false;
        }
    }
    return true;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    vector<hlopok> v(n);
    for (auto& [t, x] : v) {
        cin >> t >> x;
    }
    map<ll, vector<ll>> mp; // hlopki by time
    for (auto [t, x] : v) {
        mp[t].push_back(x * 2);
    }
    long long left = 0, right = 1e10;
    while (left + 1 < right) {
        long long mid = (left + right) / 2;
        if (check(mp, mid)) {
            left = mid;
        } else {
            right = mid;
        }
    }
    cout << fixed << setprecision(1) << (long double)(left) / 2 << '\n';
    return 0;
}
